/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public final class VWScenarioDurationPattern
implements Serializable {
    private VWScenarioWorkflowDefinition m_scenarioWFDef = null;
    private Date m_startTime = null;
    private Object m_endTime = null;
    private float m_adjustFactor = 0.0f;
    private String m_dataSource = null;

    public VWScenarioDurationPattern(Date startTime, Object endTime, float adjustFactor, String dataSource) throws VWException {
        this.setAcquireStartTime(startTime);
        this.setAcquireEndTime(endTime);
        this.setAdjustFactor(adjustFactor);
        this.setDataSource(dataSource);
    }

    protected VWScenarioDurationPattern() {
    }

    public Date getAcquireStartTime() {
        return this.m_startTime;
    }

    public void setAcquireStartTime(Date startTime) {
        this.m_startTime = startTime;
    }

    public Object getAcquireEndTime() {
        return this.m_endTime;
    }

    public void setAcquireEndTime(Object endTime) {
        this.m_endTime = endTime;
    }

    public float getAdjustFactor() {
        return this.m_adjustFactor;
    }

    public void setAdjustFactor(float adjustFactor) {
        this.m_adjustFactor = adjustFactor;
    }

    public String getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(String dataSource) {
        this.m_dataSource = dataSource;
    }

    public void validate(Vector EDefVector) throws VWException {
        VWScenarioTimeType.validate(this.getAcquireStartTime(), this.m_scenarioWFDef.getScenario().getAbsoluteStartTime(), 6, this.getScenarioWorkflow().getWorkflowDefinition().getName(), this.getScenarioWorkflow().getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absAcquireStartTime = VWScenarioTimeType.getAbsoluteTime(this.getAcquireStartTime());
        VWScenarioTimeType.validate(this.getAcquireEndTime(), absAcquireStartTime, 6, this.getScenarioWorkflow().getWorkflowDefinition().getName(), this.getScenarioWorkflow().getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absAcquireEndTime = VWScenarioTimeType.getAbsoluteTime(this.getAcquireEndTime());
        if (absAcquireStartTime != null && absAcquireEndTime != null && absAcquireEndTime.compareTo(absAcquireStartTime) <= 0) {
            VWString theMessage = new VWString("sim.api.VWScenarioDurationPattern.AcquireEndTimeOutOfRange", "The duration acquire end date must be greater than the acquire start date.");
            VWScenarioValidationError theError = new VWScenarioValidationError(6, 1, this.getScenarioWorkflow().getWorkflowDefinition().getName(), null, theMessage.toString(), this.getScenarioWorkflow().getWorkflowDefinition().getName());
            EDefVector.addElement(theError);
        }
    }

    protected void setScenarioWorkflow(VWScenarioWorkflowDefinition scenarioWFDef) {
        this.m_scenarioWFDef = scenarioWFDef;
    }

    protected VWScenarioWorkflowDefinition getScenarioWorkflow() {
        return this.m_scenarioWFDef;
    }
}

